unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Algorithms, MultiAlgorithms, ApproxAlgorithms, Common, ExtCtrls, ComCtrls, Spin, GraphUtils,
  Menus;

type
  TForm1 = class(TForm)
    GrpBoxOverview: TGroupBox;
    GroupBox1: TGroupBox;
    Image1: TImage;
    Label10: TLabel;
    TBScala: TTrackBar;
    CBAlwaysUpdate: TCheckBox;
    ImgBestAlgorithms: TImage;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    MainPageControl: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox3: TGroupBox;
    BtnStart: TButton;
    BtnCancel: TButton;
    BtnLoad: TButton;
    BtnSave: TButton;
    CBRealTime: TCheckBox;
    CBAutoSave: TCheckBox;
    GroupBox4: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label3: TLabel;
    SEMax_M: TSpinEdit;
    SEMax_Sigma: TSpinEdit;
    CBTextSize: TComboBox;
    SEIterations: TSpinEdit;
    BtnUpdateOptions: TButton;
    CBCreateText: TComboBox;
    MemSimpleLog: TMemo;
    GrpBoxLegende: TGroupBox;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label11: TLabel;
    SEMulti_MaxM: TSpinEdit;
    SEMulti_MaxSigma: TSpinEdit;
    CBMulti_TextSize: TComboBox;
    SEMulti_Iterations: TSpinEdit;
    CBMulti_OptionsUpdate: TButton;
    CBMulti_CreateText: TComboBox;
    Label12: TLabel;
    SEMulti_Count: TSpinEdit;
    GroupBox5: TGroupBox;
    BtnMultiStart: TButton;
    BtnMultiCancel: TButton;
    BtnMultiLoad: TButton;
    BtnMultiSave: TButton;
    CBMultiRealTime: TCheckBox;
    CBMultiAutoSave: TCheckBox;
    GrpBoxMultiLegende: TGroupBox;
    MemMultiLog: TMemo;
    CBMultilog: TCheckBox;
    CBSimpleLog: TCheckBox;
    TabSheet3: TTabSheet;
    GroupBox6: TGroupBox;
    BtnApproxStart: TButton;
    BtnApproxCancel: TButton;
    BtnApproxLoad: TButton;
    BtnApproxSave: TButton;
    CBApproxRealTime: TCheckBox;
    CBApproxAutoSave: TCheckBox;
    CBApproxLog: TCheckBox;
    GrpBoxApproxLegende: TGroupBox;
    GroupBox8: TGroupBox;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    SEApproxMaxM: TSpinEdit;
    SEApproxMaxSigma: TSpinEdit;
    CBApproxTextSize: TComboBox;
    SEApproxIterations: TSpinEdit;
    BtnApproxOptionsUptade: TButton;
    CBApproxCreateText: TComboBox;
    MemApproxLog: TMemo;
    SEApproxErrorQuote: TSpinEdit;
    PopupMenu1: TPopupMenu;
    PopSaveImage: TMenuItem;
    SaveImageDialog: TSaveDialog;
    DetailszudieserZeile1: TMenuItem;
    DetailszudieserSpalte1: TMenuItem;
    procedure BtnStartClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);

    procedure UpdateDetailImage(m, Sigma: Integer);
    procedure UpdateMainImage;
    procedure InitGlobalArrays(Mode: Integer);
    procedure InitMainImage;
    procedure BtnUpdateOptionsClick(Sender: TObject);
    procedure ImgBestAlgorithmsMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure TBScalaChange(Sender: TObject);
    procedure CBAlgorithmsClick(Sender: TObject);
    procedure CBMultiAlgorithmsClick(Sender: TObject);
    procedure CBApproxAlgorithmsClick(Sender: TObject);

    procedure ImgBestAlgorithmsMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SaveSimpleData(Filename: String);
    procedure SaveMultiData(Filename: String);
    procedure SaveApproxData(Filename: String);
    procedure BtnSaveClick(Sender: TObject);
    procedure BtnLoadClick(Sender: TObject);
    procedure CBMulti_OptionsUpdateClick(Sender: TObject);
    procedure MainPageControlChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure MainPageControlChange(Sender: TObject);
    procedure BtnMultiStartClick(Sender: TObject);
    procedure BtnMultiLoadClick(Sender: TObject);
    procedure BtnMultiSaveClick(Sender: TObject);
    procedure BtnApproxStartClick(Sender: TObject);
    procedure BtnApproxOptionsUptadeClick(Sender: TObject);
    procedure BtnApproxSaveClick(Sender: TObject);
    procedure BtnApproxLoadClick(Sender: TObject);
    procedure GenerateSaveImage(var dest: TBitmap);
    procedure PopSaveImageClick(Sender: TObject);
    procedure DetailszudieserZeile1Click(Sender: TObject);
    procedure DetailszudieserSpalte1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
    CBUseAlgorithms: Array[Searchalgorithms] of TCheckbox;
    CBMultiUseAlgorithms: Array[MultiSearchAlgorithms] of TCheckbox;
    CBApproxUseAlgorithms: Array[ApproxSearchAlgorithms] of TCheckbox;
  end;




var
  Form1: TForm1;

  Statistics: TStatistics;
  MultiStatistics: TMultiStatistics;
  ApproxStatistics: TApproxStatistics;
  
  UseAlgorithms: Array[Searchalgorithms] of Boolean;
  MultiUseAlgorithms: Array[MultiSearchalgorithms] of Boolean;
  ApproxUseAlgorithms: Array[ApproxSearchalgorithms] of Boolean;

  go_on : Boolean;

  SimpleTimeNeeded: Int64 = 0;
  MultiTimeNeeded: Int64 = 0;
  ApproxTimeNeeded: Int64 = 0;
  Scala: Double = 20;
  Suchmodus: Integer = 0; // einfach, multi

  // Fr die Einfache Suche
  ITERATIONS: Integer = 5;
  TEXTSIZE: Integer = 102400; // 100kb
  MAX_SIGMA: Integer = 20;
  MAX_M: Integer = 20;
  TextCreateMode: Integer = 0;
  lastm, lastSigma: Integer;
  H: Integer;
  W: Integer;

  // Fr die mehrfache Suche
  Multi_ITERATIONS: Integer = 5;
  Multi_TEXTSIZE: Integer = 102400; // 100kb
  Multi_MAX_SIGMA: Integer = 20;
  Multi_MAX_M: Integer = 20;
  Multi_PCount: Integer = 5;
  Multi_TextCreateMode: Integer = 0;
  Multi_lastm, Multi_lastSigma: Integer;
  Multi_H: Integer;
  Multi_W: Integer;

  // Fr die unscharfe Suche
  Approx_ITERATIONS: Integer = 5;
  Approx_TEXTSIZE: Integer = 102400; // 100kb
  Approx_MAX_SIGMA: Integer = 20;
  Approx_MAX_M: Integer = 20;
  Approx_ErrorQuote: Integer = 30;
  Approx_TextCreateMode: Integer = 0;
  Approx_lastm, Approx_lastSigma: Integer;
  Approx_H: Integer;
  Approx_W: Integer;



implementation

uses UnitDetails;

{$R *.dfm}

function GetAverageTime(aTimesArray: TTimesArray; aIdx: SearchAlgorithms): Int64;
var sum: Int64;
    i: Integer;
begin
  sum := 0;
  for i := 0 to ITERATIONS-1 do
    sum := sum + aTimesArray[i, aIdx];
  if sum = 0 then
    result := 0
  else
    result := round(sum / ITERATIONS);
end;

function GetMultiAverageTime(aMultiTimesArray: TMultiTimesArray; aIdx: MultiSearchAlgorithms): Int64;
var sum: Int64;
    i: Integer;
begin
  sum := 0;
  for i := 0 to Multi_ITERATIONS-1 do
    sum := sum + aMultiTimesArray[i, aIdx];
  if sum = 0 then
    result := 0
  else
    result := round(sum / Multi_ITERATIONS);
end;

function GetApproxAverageTime(aApproxTimesArray: TApproxTimesArray; aIdx: ApproxSearchAlgorithms): Int64;
var sum: Int64;
    i: Integer;
begin
  sum := 0;
  for i := 0 to Approx_ITERATIONS-1 do
    sum := sum + aApproxTimesArray[i, aIdx];
  if sum = 0 then
    result := 0
  else
    result := round(sum / Approx_ITERATIONS);
end;

function GetBestAlgorithm(aAverageTimeArray: TAlgTimeArray): SearchAlgorithms;
var i: SearchAlgorithms;
    min: Int64;
begin
  min := high(Int64);
  result := naiv;
  for i := low(SearchAlgorithms) to High(SearchAlgorithms) do
    if UseAlgorithms[i] and (min > aAverageTimeArray[i]) and (aAverageTimeArray[i] > 0) then
    begin
      min := aAverageTimeArray[i];
      result := i;
    end;
end;

function GetBestMultiAlgorithm(aAverageTimeArray: TMultiAlgTimeArray): MultiSearchAlgorithms;
var i: MultiSearchAlgorithms;
    min: Int64;
begin
  min := high(Int64);
  result := Multinaiv;
  for i := low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
    if MultiUseAlgorithms[i] and (min > aAverageTimeArray[i]) and (aAverageTimeArray[i] > 0) then
    begin
      min := aAverageTimeArray[i];
      result := i;
    end;
end;

function GetBestApproxAlgorithm(aAverageTimeArray: TApproxAlgTimeArray): ApproxSearchAlgorithms;
var i: ApproxSearchAlgorithms;
    min: Int64;
begin
  min := high(Int64);
  result := dp;
  for i := low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
    if ApproxUseAlgorithms[i] and (min > aAverageTimeArray[i]) and (aAverageTimeArray[i] > 0) then
    begin
      min := aAverageTimeArray[i];
      result := i;
    end;
end;

function GenerateStatisticsLog: String;
var searchedText: Int64;
begin
  result := '';
  case Suchmodus of
      0: begin
            searchedText := Int64((MAX_SIGMA-1) * Max_M * Iterations) * Int64(Textsize);
            result := 'Bentigte Zeit: ' + SekToZeitString(SimpleTimeNeeded DIV 1000) + #13#10;
      end;
      1: begin
            searchedText := Int64((Multi_MAX_SIGMA-1) * Multi_Max_M * Multi_Iterations) * Int64(Multi_Textsize);
            result := 'Bentigte Zeit: ' + SekToZeitString(MultiTimeNeeded DIV 1000) + #13#10;
      end;
      2: begin
            searchedText := Int64((Approx_MAX_SIGMA-1) * Approx_Max_M * Approx_Iterations) * Int64(Approx_Textsize);
            result := 'Bentigte Zeit: ' + SekToZeitString(ApproxTimeNeeded DIV 1000) + #13#10;
      end;
  else
    searchedtext := 0;
  end;
  result := result + 'Durchsuchter Text: ' + TextSizeToString(searchedText);
end;

procedure TForm1.InitGlobalArrays(Mode: Integer);
var i,m,s: integer;
    a: SearchAlgorithms;
    am: MultiSearchAlgorithms;
    ap: ApproxSearchAlgorithms;
begin
  case Mode of
      0: // einfache Suche
      begin
          // Verfgbare Gre pro Test bestimmen
          w := Trunc(500 / Max_M);
          h := Trunc(500 / (Max_Sigma-1));

          //quadratisch machen
          if h>w then h := w else w := h;

          // Statistik-Array initialisieren
          Setlength(Statistics, Max_M + 1);
          for i := 0 to Max_M do
            Setlength(Statistics[i], Max_Sigma + 1);

          for s := 2 to MAX_SIGMA do
            for m := 1 to MAX_M do
              for a := low(SearchAlgorithms) to high(SearchAlgorithms) do
                Statistics[m, s, a] := 0;
      end;

      1: // Mehrfache Suche
      begin
          // Verfgbare Gre pro Test bestimmen
          Multi_w := Trunc(500 / Multi_Max_M);
          Multi_h := Trunc(500 / (Multi_Max_Sigma-1));

          //quadratisch machen
          if Multi_h>Multi_w then Multi_h := Multi_w else Multi_w := Multi_h;

          // Statistik-Array initialisieren
          Setlength(MultiStatistics, Multi_Max_M + 1);
          for i := 0 to Multi_Max_M do
            Setlength(MultiStatistics[i], Multi_Max_Sigma + 1);

          for s := 2 to Multi_MAX_SIGMA do
            for m := 1 to Multi_MAX_M do
              for am := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
                MultiStatistics[m, s, am] := 0;
      end;
      2: // Unscharfe Suche
      begin
          // Verfgbare Gre pro Test bestimmen
          Approx_w := Trunc(500 / Approx_Max_M);
          Approx_h := Trunc(500 / (Approx_Max_Sigma-1));

          //quadratisch machen
          if Approx_h>Approx_w then Approx_h := Approx_w else Approx_w := Approx_h;

          // Statistik-Array initialisieren
          Setlength(ApproxStatistics, Approx_Max_M + 1);
          for i := 0 to Approx_Max_M do
            Setlength(ApproxStatistics[i], Approx_Max_Sigma + 1);

          for s := 2 to Approx_MAX_SIGMA do
            for m := 1 to Approx_MAX_M do
              for ap := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
                ApproxStatistics[m, s, ap] := 0;
      end;
  end;


  lastm := 0;
  lastSigma := 0;
  Multi_lastm := 0;
  Multi_lastSigma := 0;
  Approx_lastm := 0;
  Approx_lastSigma := 0;
end;

procedure TForm1.InitMainImage;
begin
  case Suchmodus of
      0: begin
          ImgBestAlgorithms.Width := w * Max_M;
          ImgBestAlgorithms.Height := h * (Max_Sigma-1);
      end;
      1: begin
          ImgBestAlgorithms.Width := Multi_w * (Multi_Max_M);
          ImgBestAlgorithms.Height := Multi_h * (Multi_Max_Sigma-1);
      end;
      2: begin
          ImgBestAlgorithms.Width := Approx_w * (Approx_Max_M);
          ImgBestAlgorithms.Height := Approx_h * (Approx_Max_Sigma-1);
      end;
  end;

  ImgBestAlgorithms.Picture.Bitmap.Width  := ImgBestAlgorithms.Width;
  ImgBestAlgorithms.Picture.Bitmap.Height := ImgBestAlgorithms.Height;
  ImgBestAlgorithms.Top := (GrpBoxOverview.Height - ImgBestAlgorithms.Height) Div 2;
  ImgBestAlgorithms.Left := (GrpBoxOverview.Width - ImgBestAlgorithms.Width) Div 2;
  ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := clwhite;
  ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(Rect(0,0,ImgBestAlgorithms.Width, ImgBestAlgorithms.Height));
end;

procedure TForm1.FormCreate(Sender: TObject);
var a: SearchAlgorithms;
  am: MultiSearchAlgorithms;
  ap: ApproxSearchAlgorithms;
  newShape: TShape;
  NewCheckbox: TCheckBox;
begin
  Randomize;
  SaveDialog1.InitialDir := ExtractFilePath(ParamStr(0)) + 'Daten';
  OpenDialog1.InitialDir := ExtractFilePath(ParamStr(0)) + 'Daten';

  MainPageControl.TabIndex := Suchmodus;

  GrpBoxOverview.DoubleBuffered := True;
  ImgBestAlgorithms.Picture.Bitmap := TBitmap.Create;
  InitGlobalArrays(0);
  InitGlobalArrays(1);
  InitGlobalArrays(2);
  InitMainImage;

  // Legende Initialisieren - Shapes erstellen
  for a := Low(SearchAlgorithms) to High(SearchAlgorithms) do
  begin
    NewShape := TShape.Create(Self);
    
    NewShape.Parent := GrpBoxLegende;
    NewShape.Left := 16;
    NewShape.Top := (Integer(a) + 1) * 24;
    NewShape.Width := 20;
    NewShape.Height := 20;
    NewShape.Brush.Color := Colors[a];

    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := GrpBoxLegende;
    NewCheckbox.Top := 28 + Integer(a) * 24;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := AlgorithmNames[a];
    NewCheckbox.Tag := Integer(a);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBAlgorithmsClick;
    UseAlgorithms[a] := True;
    CBUseAlgorithms[a] := NewCheckbox;
  end;

  for am := Low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
  begin
    NewShape := TShape.Create(Self);
    
    NewShape.Parent := GrpBoxMultiLegende;
    NewShape.Left := 16;
    NewShape.Top := (Integer(am) + 1) * 24;
    NewShape.Width := 20;
    NewShape.Height := 20;
    NewShape.Brush.Color := MultiColors[am];

    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := GrpBoxMultiLegende;
    NewCheckbox.Top := 28 + Integer(am) * 24;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := MultiAlgorithmNames[am];
    NewCheckbox.Tag := Integer(am);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBMultiAlgorithmsClick;
    MultiUseAlgorithms[am] := True;
    CBMultiUseAlgorithms[am] := NewCheckbox;
  end;
  for ap := Low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
  begin
    NewShape := TShape.Create(Self);
    
    NewShape.Parent := GrpBoxApproxLegende;
    NewShape.Left := 16;
    NewShape.Top := (Integer(ap) + 1) * 24;
    NewShape.Width := 20;
    NewShape.Height := 20;
    NewShape.Brush.Color := ApproxColors[ap];

    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := GrpBoxApproxLegende;
    NewCheckbox.Top := 28 + Integer(ap) * 24;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := ApproxAlgorithmNames[ap];
    NewCheckbox.Tag := Integer(ap);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBApproxAlgorithmsClick;
    ApproxUseAlgorithms[ap] := True;
    CBApproxUseAlgorithms[ap] := NewCheckbox;
  end;
  UpdateMainImage;
end;

// Daten fr aktuelles (m X Sigma)-Paar auf unteres Bild bertragen
procedure TForm1.UpdateDetailImage(m, Sigma: Integer);
var bmp: TBitmap;
    yi, len: Integer;
    a: SearchAlgorithms;
    am: MultiSearchAlgorithms;
    ap: ApproxSearchAlgorithms;

begin
  bmp := TBitmap.Create;
  bmp.Width := Image1.Width;
  bmp.Height := Image1.Height;

  case Suchmodus of
      0:  for a := Low(SearchAlgorithms) to High(SearchAlgorithms) do
          begin
            bmp.Canvas.TextOut(0, 2, Format('Alphabetgre: %d',[Sigma]));
            bmp.Canvas.TextOut(0, 19, Format('Musterlnge: %d',[m]));

            //GrpBoxOverview.Caption := Inttostr(Statistics[m, Sigma, kmp]) + '---' + IntTostr(High(Integer));

            yi := Integer(a)+2;
            bmp.Canvas.Brush.Style := bsSolid;
            bmp.Canvas.Brush.color := Colors[a];
            len := Round(Statistics[m, Sigma, a] / Scala / 1000);
            bmp.Canvas.Rectangle(Rect(0, 17*yi, len, 17*yi+15));
            bmp.Canvas.Brush.Style := bsClear;
            if len > bmp.Width - 60 then
              len := bmp.Width - 60;                      //.3f

            if Statistics[m, Sigma, a] = 0 then
                bmp.Canvas.TextOut(len, 17*yi+1, '- nicht ausgefhrt -')
            else
              bmp.Canvas.TextOut(len, 17*yi+1, Format('%.1f s',[Statistics[m, Sigma, a]/1000]));
          end;
      1:  for am := Low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
          begin
            bmp.Canvas.TextOut(0, 2, Format('Alphabetgre: %d',[Sigma]));
            bmp.Canvas.TextOut(0, 19, Format('Musterlnge: %d',[m]));

            yi := Integer(am)+2;
            bmp.Canvas.Brush.Style := bsSolid;
            bmp.Canvas.Brush.color := MultiColors[am];
            len := Round(MultiStatistics[m, Sigma, am] / Scala / 1000);
            bmp.Canvas.Rectangle(Rect(0, 17*yi, len, 17*yi+15));
            bmp.Canvas.Brush.Style := bsClear;
            if len > bmp.Width - 60 then
              len := bmp.Width - 60;                      //.3f

            if MultiStatistics[m, Sigma, am] = 0 then
                bmp.Canvas.TextOut(len, 17*yi+1, '- nicht ausgefhrt -')
            else
              bmp.Canvas.TextOut(len, 17*yi+1, Format('%.1f s',[MultiStatistics[m, Sigma, am]/1000]));
          end;
      2:  for ap := Low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
          begin
            bmp.Canvas.TextOut(0, 2, Format('Alphabetgre: %d',[Sigma]));
            bmp.Canvas.TextOut(0, 19, Format('Musterlnge: %d',[m]));

            yi := Integer(ap)+2;
            bmp.Canvas.Brush.Style := bsSolid;
            bmp.Canvas.Brush.color := ApproxColors[ap];
            len := Round(ApproxStatistics[m, Sigma, ap] / Scala / 1000);
            bmp.Canvas.Rectangle(Rect(0, 17*yi, len, 17*yi+15));
            bmp.Canvas.Brush.Style := bsClear;
            if len > bmp.Width - 60 then
              len := bmp.Width - 60;                      //.3f

            if ApproxStatistics[m, Sigma, ap] = 0 then
                bmp.Canvas.TextOut(len, 17*yi+1, '- nicht ausgefhrt -')
            else
              bmp.Canvas.TextOut(len, 17*yi+1, Format('%.1f s',[ApproxStatistics[m, Sigma, ap]/1000]));
          end;
  end;
  Image1.Picture.Bitmap.Assign(bmp);
  Image1.Refresh;
  bmp.Free;
end;

procedure TForm1.UpdateMainImage;
var
    s,m: Integer;
    best: SearchAlgorithms;
    multibest: MultiSearchAlgorithms;
    approxbest: ApproxSearchAlgorithms;
begin
    case Suchmodus of
        0: begin
            for s := 2 to Max_Sigma do
                for m := 1 to Max_M do
                begin
                    best := GetBestAlgorithm(Statistics[m][s]);

                    ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := Colors[best];
                    if (w > 6) and (h > 6) then
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                            rect((m-1)*W, (Max_Sigma-s)*H,
                                 (m  )*W, (Max_Sigma-s+1)*H))
                    else
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                            rect((m-1)*W, (Max_Sigma-s)*H,
                                 (m  )*W, (Max_Sigma-s+1)*H));
                end;
        end;
        1: begin
            for s := 2 to Multi_Max_Sigma do
                for m := 1 to Multi_Max_M do
                begin
                    multibest := GetBestMultiAlgorithm(MultiStatistics[m][s]);

                    ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := MultiColors[multibest];
                    if (Multi_w > 6) and (Multi_h > 6) then
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                            rect((m-1)*Multi_W, (Multi_Max_Sigma-s)*Multi_H,
                                 (m  )*Multi_W, (Multi_Max_Sigma-s+1)*Multi_H))
                    else
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                            rect((m-1)*Multi_W, (Multi_Max_Sigma-s)*Multi_H,
                                 (m  )*Multi_W, (Multi_Max_Sigma-s+1)*Multi_H));
                end;

        end;
        2: begin
            for s := 2 to Approx_Max_Sigma do
                for m := 1 to Approx_Max_M do
                begin
                    Approxbest := GetBestApproxAlgorithm(ApproxStatistics[m][s]);

                    ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := ApproxColors[Approxbest];
                    if (Approx_w > 6) and (Approx_h > 6) then
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                            rect((m-1)*Approx_W, (Approx_Max_Sigma-s)*Approx_H,
                                 (m  )*Approx_W, (Approx_Max_Sigma-s+1)*Approx_H))
                    else
                      ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                            rect((m-1)*Approx_W, (Approx_Max_Sigma-s)*Approx_H,
                                 (m  )*Approx_W, (Approx_Max_Sigma-s+1)*Approx_H));
                end;

        end;
    end;
end;

procedure TForm1.BtnStartClick(Sender: TObject);
var i,m, Sigma: Integer;
    p, t, FileName,mb: String;
    a, best,firstalg: SearchAlgorithms;
    Times: TTimesArray;
    AverageTimes : TAlgTimeArray;
    Results: TSimpleTrefferArray;
    start, ende: Int64;
    Firstresult : TSimpleTrefferList;
    s,e, freq: Int64;
    first, done: Boolean;
begin
  QueryPerformanceFrequency(freq);
  if freq = 0 then
  begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
  end;

  go_on := True;
  start := GetTickCount;
  Setlength(Times, Iterations);
  FirstResult := NIL;

  for a := low(SearchAlgorithms) to high(SearchAlgorithms) do
    if CBSimplelog.Checked then
      results[a] := TSimpleTrefferList.Create
    else
      results[a] := Nil;

  for Sigma := 2 to MAX_SIGMA do
  begin
    if TextCreateMode = 2 then
      t := GenerateRandomString(TEXTSIZE, Sigma);
    for m := 1 to MAX_M do
    begin
        if TextCreateMode = 1 then
          t := GenerateRandomString(TEXTSIZE, Sigma);
        for i := 0 to ITERATIONS-1 do
        begin
            if TextCreateMode = 0 then
              t := GenerateRandomString(TEXTSIZE, Sigma);

            p := GenerateRandomString(m, Sigma);
            firstalg := ppp;

            if assigned(FirstResult) then Firstresult.Clear;
            first := True;
            // Alle Algorithmen durchtesten
            for a := low(SearchAlgorithms) to high(SearchAlgorithms) do
            begin
              if UseAlgorithms[a] then
              begin
                  if assigned(results[a]) then
                      Results[a].Clear;

                  if CBRealTime.Checked then
                      SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);

                  QueryPerformanceCounter(s);
                  done := SimpleSearch(t,p,a,Results[a]);
                  if done then
                  begin
                      QueryPerformanceCounter(e);
                      Times[i,a] := Round((e-s)*1000000000/freq);
                  end else
                      Times[i,a] := 0;
                  SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);

                  if done and first then
                  begin
                      Firstresult := Results[a];
                      first := false;
                      firstalg := a;
                  end;

                  if done and (Not SimpleTrefferAreEqual(Results[a], Firstresult)) then
                  begin
                      MemSimpleLog.Lines.Add(Format('%s hat falsches Ergebnis geliefert bei m=%d, Sigma=%d',[AlgorithmNames[a],m,Sigma]));
                      MemSimpleLog.Lines.Add(Format('%s: %d, %s: %d', [AlgorithmNames[firstalg],Results[firstalg].Count, AlgorithmNames[a], Results[a].Count]));
                  end;
              end else
                  Times[i,a] := 0;
            end;
        end;
        for a := low(SearchAlgorithms) to high(SearchAlgorithms) do
        begin
          if UseAlgorithms[a] then
          begin
              AverageTimes[a] := GetAverageTime(Times, a);
              Statistics[m, Sigma, a] := AverageTimes[a];
          end else
              Statistics[m, Sigma, a] := 0;
        end;
        best := GetBestAlgorithm(AverageTimes);

        ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := Colors[best];
        if (w > 6) and (h > 6) then
            ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                  rect((m-1)*W, (Max_Sigma-Sigma)*H,
                       (m  )*W, (Max_Sigma-Sigma+1)*H))
        else
            ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                  rect((m-1)*W, (Max_Sigma-Sigma)*H,
                       (m  )*W, (Max_Sigma-Sigma+1)*H));
        ImgBestAlgorithms.Refresh;
        Application.ProcessMessages;
        if not go_on then exit;
    end;
  end;
    ende := GetTickCount;
    SimpleTimeNeeded := Ende - Start;
    MemSimpleLog.Lines.Add(GenerateStatisticsLog);

    if CBAutoSave.Checked then
    begin
      case TextSize  of
          10240     : mb := '10kb';
          102400    : mb := '100kb';
          1024*1024 : mb := '1mb';
          1024*10240: mb := '10mb';
          else        mb := '50mb';
      end;
      FileName := ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('%s_%d_%d_%s_(%d).dpl',
                      [StringReplace(DateTimeToStr(Now), ':','',[rfReplaceAll]), Max_m, Max_Sigma, mb, Iterations]);
      SaveSimpleData(FileName);

    end;
    go_on := False;
end;

procedure TForm1.BtnMultiStartClick(Sender: TObject);
var i,m, Sigma, pc, pi: Integer;
    t, FileName,mb: String;
    P: TStrings;
    a, best,firstalg: MultiSearchAlgorithms;
    Times: TMultiTimesArray;
    AverageTimes : TMultiAlgTimeArray;
    Results: TMultiAlgTrefferArray;
    start, ende: Int64;
    FirstResult : TMultiTrefferList;
    first, done: Boolean;
    s,e, freq: Int64;
begin
  QueryPerformanceFrequency(freq);
  if freq = 0 then
  begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
  end;

  go_on := True;
  start := GetTickCount;
  Setlength(Times, Multi_Iterations);
  // Liste mit Strings initialisieren
  P := TStringlist.Create;
  P.Capacity := Multi_PCount;
  for i := 0 to Multi_PCount-1 do
    P.Add('');

  FirstResult := NIL;
  firstalg := multinaiv;

  for a := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
    if CBMultilog.Checked then
      results[a] := TMultiTrefferList.Create
    else
      results[a] := Nil;

  for Sigma := 2 to Multi_MAX_SIGMA do
  begin
    if Multi_TextCreateMode = 2 then
      t := GenerateRandomString(Multi_TEXTSIZE, Sigma);
    for m := 1 to Multi_MAX_M do
    begin
        if Multi_TextCreateMode = 1 then
          t := GenerateRandomString(Multi_TEXTSIZE, Sigma);
        for i := 0 to Multi_ITERATIONS-1 do
        begin
            if Multi_TextCreateMode = 0 then
              t := GenerateRandomString(Multi_TEXTSIZE, Sigma);

            for pc := 0 to P.Count-1 do
              P[pc] := GenerateRandomString(m {+ Random(m)}, Sigma);

            // alte Ergebnisse lschen
            if assigned(FirstResult) then Firstresult.Clear;
            first := True;

            // Alle Algorithmen durchtesten
            for a := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
            begin
              if MultiUseAlgorithms[a] then
              begin
                  // ggf. vorhandene Ergebnisliste freigeben
                  if assigned(results[a]) then
                      Results[a].Clear;

                  if CBMultiRealTime.Checked then
                      SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);

                  QueryPerformanceCounter(s);
                  done := MultiSearch(t,p,a,Results[a]);
                  if done then
                  begin
                      QueryPerformanceCounter(e);
                      Times[i,a] := Round((e-s)*1000000000/freq);
                  end else
                      Times[i,a] := 0;
                  SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);

                  if assigned(results[a]) then Results[a].Sort(TrefferSort);

                  if done and first then
                  begin
                    Firstresult := Results[a];
                    first := false;
                    firstalg := a;
                  end;

                  if done and (Not MultiTrefferAreEqual(Results[a], Firstresult)) then
                  begin
                    MemMultiLog.Lines.Add(Format('%s hat falsches Ergebnis geliefert bei m=%d, Sigma=%d',[MultiAlgorithmNames[a],m,Sigma]));
                    MemMultiLog.Lines.Add(Format('%s: %d, %s: %d', [MultiAlgorithmNames[firstalg],Results[firstalg].Count, MultiAlgorithmNames[a], Results[a].Count]));
                    MemMultiLog.Lines.Add('==================');
                  end;
              end else
                  Times[i,a] := 0;
            end;
        end;
        for a := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
        begin
          if MultiUseAlgorithms[a] then
          begin
              AverageTimes[a] := GetMultiAverageTime(Times, a);
              MultiStatistics[m, Sigma, a] := AverageTimes[a];
          end else
              MultiStatistics[m, Sigma, a] := 0;
        end;
        best := GetBestMultiAlgorithm(AverageTimes);

        ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := MultiColors[best];
        if (Multi_w > 6) and (Multi_h > 6) then
            ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                  rect((m-1)*Multi_W, (Multi_Max_Sigma-Sigma)*Multi_H,
                       (m  )*Multi_W, (Multi_Max_Sigma-Sigma+1)*Multi_H))
        else
            ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                  rect((m-1)*Multi_W, (Multi_Max_Sigma-Sigma)*Multi_H,
                       (m  )*Multi_W, (Multi_Max_Sigma-Sigma+1)*Multi_H));
        ImgBestAlgorithms.Refresh;
        Application.ProcessMessages;
        if not go_on then
        begin
            // Aufrumen und raus
            for a := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
              if assigned(results[a]) then results[a].Free;
            P.Free;
            exit;
        end;
    end;
  end;
  
  for a := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
    if assigned(results[a]) then results[a].Free;
  P.Free;

    ende := GetTickCount;
    MultiTimeNeeded := Ende - Start;
    MemMultiLog.Lines.Add(GenerateStatisticsLog);
    go_on := False;

    if CBMultiAutoSave.Checked then
    begin
      case Multi_TextSize  of
          10240     : mb := '10kb';
          102400    : mb := '100kb';
          1024*1024 : mb := '1mb';
          1024*10240: mb := '10mb';
          else        mb := '50mb';
      end;
      FileName := ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('Multi_%s_%d_%d_%s_%d_(%d).dpl',
                      [StringReplace(DateTimeToStr(Now), ':','',[rfReplaceAll]), Multi_Max_m, Multi_Max_Sigma, mb, Multi_PCount, Multi_Iterations]);
      SaveMultiData(FileName);

    end;
end;


procedure TForm1.BtnCancelClick(Sender: TObject);
begin
  go_on := False;
end;

procedure TForm1.BtnUpdateOptionsClick(Sender: TObject);
begin
  // Werte ndern
  ITERATIONS := SEIterations.Value;
  case CBTextSize.ItemIndex of
    0: TextSize := 10240;
    1: TextSize := 102400;
    2: TextSize := 1024*1024;
    3: TextSize := 1024*10240;
    else TextSize := 1024*10240*5;
  end;
  MAX_SIGMA := SEMax_Sigma.Value;
  MAX_M := SEMax_M.Value;
  TextCreateMode := CBCreateText.ItemIndex;
  // neu Initialisieren
  InitGlobalArrays(0);
  InitMainImage;
  UpdateMainImage;
end;

procedure TForm1.CBMulti_OptionsUpdateClick(Sender: TObject);
begin
  // Werte ndern
  Multi_ITERATIONS := SEMulti_Iterations.Value;
  case CBMulti_TextSize.ItemIndex of
    0: Multi_TextSize := 10240;
    1: Multi_TextSize := 102400;
    2: Multi_TextSize := 1024*1024;
    3: Multi_TextSize := 1024*10240;
    else Multi_TextSize := 1024*10240*5;
  end;
  Multi_MAX_SIGMA := SEMulti_MaxSigma.Value;
  Multi_MAX_M := SEMulti_MaxM.Value;
  Multi_PCount := SEMulti_Count.Value;
  Multi_TextCreateMode := CBMulti_CreateText.ItemIndex;
  // neu Initialisieren
  InitGlobalArrays(1);
  InitMainImage;
  UpdateMainImage;
end;

// Details zum aktuellen (m X Sigma)-Paar im unteren Bild ausgeben
procedure TForm1.ImgBestAlgorithmsMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var m, Sigma: Integer;
begin
  // aus den Koordinaten x,y m und Sigma berechnen
  case SuchModus of
      0: begin
          m := x Div w + 1;
          Sigma := Max_Sigma - (y Div h);
          if (m=lastm) and (Sigma=lastSigma) then Exit;
          if (CBAlwaysUpdate.Checked) then
          begin
            UpdateDetailImage(m, Sigma);
            lastm := m;
            lastSigma := Sigma;
          end;
      end;
      1: begin
          m := x Div Multi_w + 1;
          Sigma := Multi_Max_Sigma - (y Div Multi_h);
          if (m=Multi_lastm) and (Sigma=Multi_lastSigma) then Exit;
          if (CBAlwaysUpdate.Checked) then
          begin
            UpdateDetailImage(m, Sigma);
            Multi_lastm := m;
            Multi_lastSigma := Sigma;
          end;
      end;
      2: begin
          m := x Div Approx_w + 1;
          Sigma := Approx_Max_Sigma - (y Div Approx_h);
          if (m=Approx_lastm) and (Sigma=Approx_lastSigma) then Exit;
          if (CBAlwaysUpdate.Checked) then
          begin
            UpdateDetailImage(m, Sigma);
            Approx_lastm := m;
            Approx_lastSigma := Sigma;
          end;
      end;
  end;
end;
procedure TForm1.ImgBestAlgorithmsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var m, Sigma: Integer;
begin
  case Suchmodus of
      0: begin
          m := x Div w + 1;
          Sigma := Max_Sigma - (y Div h);
          UpdateDetailImage(m, Sigma);
          lastm := m;
          lastSigma := Sigma;
      end;
      1: begin
          m := x Div Multi_w + 1;
          Sigma := Multi_Max_Sigma - (y Div Multi_h);
          UpdateDetailImage(m, Sigma);
          Multi_lastm := m;
          Multi_lastSigma := Sigma;
      end;
      2: begin
          m := x Div Approx_w + 1;
          Sigma := Approx_Max_Sigma - (y Div Approx_h);
          UpdateDetailImage(m, Sigma);
          Approx_lastm := m;
          Approx_lastSigma := Sigma;
      end;
  end;
end;

// nderung der Bildskalierung
procedure TForm1.TBScalaChange(Sender: TObject);
begin
  if TextSize >= 1024*10240*5 then
    Scala := TBScala.Position * 2
  else
    Scala := TBScala.Position/10;
  case Suchmodus of
    0: UpdateDetailImage(lastm, lastSigma);
    1:  UpdateDetailImage(Multi_lastm, Multi_lastSigma);
    2:  UpdateDetailImage(Approx_lastm, Approx_lastSigma);
  end;
end;

procedure TForm1.CBAlgorithmsClick(Sender: TObject);
begin
  if Suchmodus <> 0 then exit;
  UseAlgorithms[SearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  UpdateMainImage;
end;

procedure TForm1.CBMultiAlgorithmsClick(Sender: TObject);
begin
  if Suchmodus <> 1 then exit;
  MultiUseAlgorithms[MultiSearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  UpdateMainImage;
end;

procedure TForm1.CBApproxAlgorithmsClick(Sender: TObject);
begin
  if Suchmodus <> 2 then exit;
  ApproxUseAlgorithms[ApproxSearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  UpdateMainImage;
end;

procedure TForm1.SaveSimpleData(Filename: String);
var stream: TMemoryStream;
    s,m, Mode: Integer;
    a: SearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  Stream.Size := (MAX_SIGMA-1 + Max_M + Integer(High(SearchAlgorithms))+1 + 1)* SizeOf(Int64)
             + (7*sizeof(Integer));

  // nochmal neu: Modus speichern (einfach, mehrfach, unscharf)
  Mode := 0;
  Stream.Write(Mode, SizeOf(Mode));

  Stream.Write(Max_M, Sizeof(Integer));
  Stream.Write(MAX_SIGMA, Sizeof(Integer));
  Stream.Write(TextSize, Sizeof(Integer));
  Stream.Write(ITERATIONS, Sizeof(Integer));
  Stream.Write(TBScala.Position, SizeOf(Integer));
  Stream.Write(SimpleTimeNeeded, SizeOf(Int64));
  // jetzt neu:
  Stream.Write(TextCreateMode, SizeOf(Integer));

  for s := 2 to Max_Sigma do
    for m := 1 to Max_M do
      for a := Low(SearchAlgorithms) to High(SearchAlgorithms) do
        Stream.Write(Statistics[m][s][a], sizeof(Int64));
  Stream.SaveToFile(FileName);
end;

procedure TForm1.BtnSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    SaveSimpleData(SaveDialog1.FileName);
end;

procedure TForm1.SaveMultiData(Filename: String);
var stream: TMemoryStream;
    s,m, Mode: Integer;
    a: MultiSearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  Stream.Size := (Multi_MAX_SIGMA-1 + Multi_Max_M + Integer(High(MultiSearchAlgorithms))+1 + 1)* SizeOf(Int64)
             + (8*sizeof(Integer));

  // nochmal neu: Modus speichern (einfach, mehrfach, unscharf)
  Mode := 1;
  Stream.Write(Mode, SizeOf(Mode));

  Stream.Write(Multi_Max_M, Sizeof(Integer));
  Stream.Write(Multi_MAX_SIGMA, Sizeof(Integer));
  Stream.Write(Multi_TextSize, Sizeof(Integer));
  Stream.Write(Multi_ITERATIONS, Sizeof(Integer));
  Stream.Write(Multi_PCount, Sizeof(Integer));
  Stream.Write(TBScala.Position, SizeOf(Integer));
  Stream.Write(MultiTimeNeeded, SizeOf(Int64));
  // jetzt neu:
  Stream.Write(Multi_TextCreateMode, SizeOf(Integer));

  for s := 2 to Multi_Max_Sigma do
    for m := 1 to Multi_Max_M do
      for a := Low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
        Stream.Write(MultiStatistics[m][s][a], sizeof(Int64));
  Stream.SaveToFile(FileName);
end;

procedure TForm1.BtnMultiSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    SaveMultiData(SaveDialog1.FileName);
end;

procedure TForm1.SaveApproxData(Filename: String);
var stream: TMemoryStream;
    s,m, Mode: Integer;
    a: ApproxSearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  Stream.Size := (Approx_MAX_SIGMA-1 + Approx_Max_M + Integer(High(ApproxSearchAlgorithms))+1 + 1)* SizeOf(Int64)
             + (8*sizeof(Integer));

  // nochmal neu: Modus speichern (einfach, mehrfach, unscharf)
  Mode := 2;
  Stream.Write(Mode, SizeOf(Mode));

  Stream.Write(Approx_Max_M, Sizeof(Integer));
  Stream.Write(Approx_MAX_SIGMA, Sizeof(Integer));
  Stream.Write(Approx_TextSize, Sizeof(Integer));
  Stream.Write(Approx_ITERATIONS, Sizeof(Integer));
  Stream.Write(Approx_ErrorQuote, Sizeof(Integer));
  Stream.Write(TBScala.Position, SizeOf(Integer));
  Stream.Write(ApproxTimeNeeded, SizeOf(Int64));
  // jetzt neu:
  Stream.Write(Approx_TextCreateMode, SizeOf(Integer));

  for s := 2 to Approx_Max_Sigma do
    for m := 1 to Approx_Max_M do
      for a := Low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
        Stream.Write(ApproxStatistics[m][s][a], sizeof(Int64));
  Stream.SaveToFile(FileName);
end;

procedure TForm1.BtnApproxSaveClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    SaveApproxData(SaveDialog1.FileName);
end;

procedure TForm1.BtnLoadClick(Sender: TObject);
var Stream: TMemoryStream;
    s,m,p: Integer;
    a,best: SearchAlgorithms;
    mode: Integer;
begin
  if OpenDialog1.Execute then
  begin
      Stream := TMemoryStream.Create;
      Stream.LoadFromFile(OpenDialog1.FileName);

      // nochmal neu: Modus laden (einfach, mehrfach, unscharf)
      Stream.Read(Mode, SizeOf(Mode));
      if Mode = 0 then
      begin
          Stream.Read(Max_M, Sizeof(Integer));
          Stream.Read(MAX_SIGMA, Sizeof(Integer));
          Stream.Read(TextSize, Sizeof(Integer));
          Stream.Read(ITERATIONS, Sizeof(Integer));
          Stream.Read(p, SizeOf(Integer));
          Stream.Read(SimpleTimeNeeded, SizeOf(Int64));
          // jetzt neu:
          Stream.Read(TextCreateMode, SizeOf(Integer));


          TBScala.Position := p;
          CBCreateText.ItemIndex := TextCreateMode;
          SEMax_M.Value := Max_M;
          SEMax_Sigma.Value := Max_Sigma;
          case TextSize  of
              10240     : CBTextSize.ItemIndex := 0;
              102400    : CBTextSize.ItemIndex := 1;
              1024*1024 : CBTextSize.ItemIndex := 2;
              1024*10240: CBTextSize.ItemIndex := 3;
              else        CBTextSize.ItemIndex := 4;
          end;
          SEIterations.Value := Iterations;
          InitGlobalArrays(0);
          InitMainImage;

          for s := 2 to Max_Sigma do
            for m := 1 to Max_M do
            begin
                for a := Low(SearchAlgorithms) to High(SearchAlgorithms) do
                  Stream.Read(Statistics[m][s][a], sizeof(Int64));
                best := GetBestAlgorithm(Statistics[m][s]);

                ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := Colors[best];
                if (w > 6) and (h > 6) then
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                        rect((m-1)*W, (Max_Sigma-s)*H,
                             (m  )*W, (Max_Sigma-s+1)*H))
                else
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                        rect((m-1)*W, (Max_Sigma-s)*H,
                             (m  )*W, (Max_Sigma-s+1)*H));
            end;

          MemSimpleLog.Lines.Add(GenerateStatisticsLog);
      end else
            MessageDlg('Keine Datei zur einfachen Mustersuche. Vorgang abgebrochen.', mterror, [mbok], 0 );
  end;
end;

procedure TForm1.BtnMultiLoadClick(Sender: TObject);
var Stream: TMemoryStream;
    s,m,p: Integer;
    a,best: MultiSearchAlgorithms;
    mode: Integer;
begin
  if OpenDialog1.Execute then
  begin
      Stream := TMemoryStream.Create;
      Stream.LoadFromFile(OpenDialog1.FileName);


      Stream.Read(Mode, SizeOf(Mode));
      if Mode = 1 then
      begin
          Stream.Read(Multi_Max_M, Sizeof(Integer));
          Stream.Read(Multi_MAX_SIGMA, Sizeof(Integer));
          Stream.Read(Multi_TextSize, Sizeof(Integer));
          Stream.Read(Multi_ITERATIONS, Sizeof(Integer));
          //----Multi
          Stream.Read(Multi_PCount, Sizeof(Integer));
          //----Multi
          Stream.Read(p, SizeOf(Integer));
          Stream.Read(MultiTimeNeeded, SizeOf(Int64));
          Stream.Read(Multi_TextCreateMode, SizeOf(Integer));


          TBScala.Position := p;
          SEMulti_Count.Value := Multi_PCount;
          CBMulti_CreateText.ItemIndex := Multi_TextCreateMode;
          SEMulti_MaxM.Value := Multi_Max_M;
          SEMulti_MaxSigma.Value := Multi_Max_Sigma;
          case Multi_TextSize  of
              10240     : CBMulti_TextSize.ItemIndex := 0;
              102400    : CBMulti_TextSize.ItemIndex := 1;
              1024*1024 : CBMulti_TextSize.ItemIndex := 2;
              1024*10240: CBMulti_TextSize.ItemIndex := 3;
              else        CBMulti_TextSize.ItemIndex := 4;
          end;
          SEMulti_Iterations.Value := Multi_Iterations;
          InitGlobalArrays(1);
          InitMainImage;

          for s := 2 to Multi_Max_Sigma do
            for m := 1 to Multi_Max_M do
            begin
                for a := Low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
                  Stream.Read(MultiStatistics[m][s][a], sizeof(Int64));
                best := GetBestMultiAlgorithm(MultiStatistics[m][s]);

                ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := MultiColors[best];
                if (Multi_w > 6) and (Multi_h > 6) then
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                        rect((m-1)*Multi_W, (Multi_Max_Sigma-s)*Multi_H,
                             (m  )*Multi_W, (Multi_Max_Sigma-s+1)*Multi_H))
                else
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                        rect((m-1)*Multi_W, (Multi_Max_Sigma-s)*Multi_H,
                             (m  )*Multi_W, (Multi_Max_Sigma-s+1)*Multi_H));
            end;

          MemMultiLog.Lines.Add(GenerateStatisticsLog);
      end else
            MessageDlg('Keine Datei zur multiplen Mustersuche. Vorgang abgebrochen.', mterror, [mbok], 0 );
  end;
end;

procedure TForm1.BtnApproxLoadClick(Sender: TObject);
var Stream: TMemoryStream;
    s,m,p: Integer;
    a,best: ApproxSearchAlgorithms;
    mode: Integer;
begin
  if OpenDialog1.Execute then
  begin
      Stream := TMemoryStream.Create;
      Stream.LoadFromFile(OpenDialog1.FileName);


      Stream.Read(Mode, SizeOf(Mode));
      if Mode = 2 then
      begin
          Stream.Read(Approx_Max_M, Sizeof(Integer));
          Stream.Read(Approx_MAX_SIGMA, Sizeof(Integer));
          Stream.Read(Approx_TextSize, Sizeof(Integer));
          Stream.Read(Approx_ITERATIONS, Sizeof(Integer));
          //----Multi
          Stream.Read(Approx_ErrorQuote, Sizeof(Integer));
          //----Multi
          Stream.Read(p, SizeOf(Integer));
          Stream.Read(ApproxTimeNeeded, SizeOf(Int64));
          Stream.Read(Approx_TextCreateMode, SizeOf(Integer));


          TBScala.Position := p;
          SEApproxErrorQuote.Value := Approx_ErrorQuote;
          CBApproxCreateText.ItemIndex := Approx_TextCreateMode;
          SEApproxMaxM.Value := Approx_Max_M;
          SEApproxMaxSigma.Value := Approx_Max_Sigma;
          case Approx_TextSize  of
              10240     : CBApproxTextSize.ItemIndex := 0;
              102400    : CBApproxTextSize.ItemIndex := 1;
              1024*1024 : CBApproxTextSize.ItemIndex := 2;
              1024*10240: CBApproxTextSize.ItemIndex := 3;
              else        CBApproxTextSize.ItemIndex := 4;
          end;
          SEApproxIterations.Value := Approx_Iterations;
          InitGlobalArrays(2);
          InitMainImage;

          for s := 2 to Approx_Max_Sigma do
            for m := 1 to Approx_Max_M do
            begin
                for a := Low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
                  Stream.Read(ApproxStatistics[m][s][a], sizeof(Int64));
                best := GetBestApproxAlgorithm(ApproxStatistics[m][s]);

                ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := ApproxColors[best];
                if (Approx_w > 6) and (Approx_h > 6) then
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                        rect((m-1)*Approx_W, (Approx_Max_Sigma-s)*Approx_H,
                             (m  )*Approx_W, (Approx_Max_Sigma-s+1)*Approx_H))
                else
                  ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                        rect((m-1)*Approx_W, (Approx_Max_Sigma-s)*Approx_H,
                             (m  )*Approx_W, (Approx_Max_Sigma-s+1)*Approx_H));
            end;

          MemApproxLog.Lines.Add(GenerateStatisticsLog);
      end else
            MessageDlg('Keine Datei zur unscharfen Mustersuche. Vorgang abgebrochen.', mterror, [mbok], 0 );
  end;
end;

procedure TForm1.MainPageControlChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  AllowChange := Not go_on;
end;

procedure TForm1.MainPageControlChange(Sender: TObject);
begin
  Suchmodus := MainPageControl.ActivePageIndex;
  InitMainImage;
  UpdateMainImage;
end;



//........................



function isBitSet( const num: Int64; const i: Integer ) : Boolean; 
begin 
  Result := (num and (Int64(1) shl i)) <> 0;
end;

procedure TForm1.BtnApproxStartClick(Sender: TObject);
var i,m, Sigma, pc, pi: Integer;
    t, FileName,mb: String;
    p: String;
    a, best,firstalg: ApproxSearchAlgorithms;
    Times: TApproxTimesArray;
    AverageTimes : TApproxAlgTimeArray;
    Results: TApproxTrefferArray;
    start, ende: Int64;
    FirstResult : TApproxTrefferList;
    first, done: Boolean;
    s,e, freq: Int64;
begin
  QueryPerformanceFrequency(freq);
  if freq = 0 then
  begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
  end;

  go_on := True;
  start := GetTickCount;
  Setlength(Times, Approx_Iterations);


  FirstResult := NIL;
  firstalg := dp;

  for a := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
    if CBApproxlog.Checked then
      results[a] := TApproxTrefferList.Create
    else
      results[a] := Nil;



  for Sigma := 2 to Approx_MAX_SIGMA do
  begin
    if Approx_TextCreateMode = 2 then
      t := GenerateRandomString(Approx_TEXTSIZE, Sigma);
    for m := 1 to Approx_MAX_M do
    begin
        if Approx_TextCreateMode = 1 then
          t := GenerateRandomString(Approx_TEXTSIZE, Sigma);
        for i := 0 to Approx_ITERATIONS-1 do
        begin
            if Approx_TextCreateMode = 0 then
              t := GenerateRandomString(Approx_TEXTSIZE, Sigma);

            p := GenerateRandomString(m, Sigma);

            // alte Ergebnisse lschen
            if assigned(FirstResult) then Firstresult.Clear;
            first := True;

            // Alle Algorithmen durchtesten
            for a := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
            begin
              if ApproxUseAlgorithms[a] then
              begin
                  // ggf. vorhandene Ergebnisliste freigeben
                  if assigned(results[a]) then
                      Results[a].Clear;

                  if CBApproxRealTime.Checked then
                      SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);

                  QueryPerformanceCounter(s);
                  done := ApproxSearch(t,p,Approx_ErrorQuote, a,Results[a], EM_RELATIVE);
                  if done then
                  begin
                      QueryPerformanceCounter(e);
                      Times[i,a] := Round((e-s)*1000000000/freq);
                  end else
                      Times[i,a] := 0;
                  SetPriorityClass(GetCurrentProcess, NORMAL_PRIORITY_CLASS);

                  if done and first then
                  begin
                    Firstresult := Results[a];
                    first := false;
                    firstalg := a;
                  end;

                  if done and (Not ApproxTrefferAreEqual(Results[a], Firstresult)) then
                  begin
                    MemApproxLog.Lines.Add(Format('%s hat falsches Ergebnis geliefert bei m=%d, Sigma=%d',[ApproxAlgorithmNames[a],m,Sigma]));
                    MemApproxLog.Lines.Add(Format('%s: %d, %s: %d', [ApproxAlgorithmNames[firstalg],Results[firstalg].Count, ApproxAlgorithmNames[a], Results[a].Count]));
                    MemApproxLog.Lines.Add(t + ' -- ' + p);
                    MemApproxLog.Lines.Add(OutputApproxTrefferList(Results[firstalg]));
                    MemApproxLog.Lines.Add(OutputApproxTrefferList(Results[a]));
                    MemApproxLog.Lines.Add('==================');
                  end;
              end else
                  Times[i,a] := 0;
            end;
        end;
        for a := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
        begin
          if ApproxUseAlgorithms[a] then
          begin
              AverageTimes[a] := GetApproxAverageTime(Times, a);
              ApproxStatistics[m, Sigma, a] := AverageTimes[a];
          end else
              ApproxStatistics[m, Sigma, a] := 0;
        end;
        best := GetBestApproxAlgorithm(AverageTimes);

        ImgBestAlgorithms.Picture.Bitmap.Canvas.Brush.Color := ApproxColors[best];
        if (Approx_w > 6) and (Approx_h > 6) then
            ImgBestAlgorithms.Picture.Bitmap.Canvas.Rectangle(
                  rect((m-1)*Approx_W, (Approx_Max_Sigma-Sigma)*Approx_H,
                       (m  )*Approx_W, (Approx_Max_Sigma-Sigma+1)*Approx_H))
        else
            ImgBestAlgorithms.Picture.Bitmap.Canvas.FillRect(
                  rect((m-1)*Approx_W, (Approx_Max_Sigma-Sigma)*Approx_H,
                       (m  )*Approx_W, (Approx_Max_Sigma-Sigma+1)*Approx_H));
        ImgBestAlgorithms.Refresh;
        Application.ProcessMessages;
        if not go_on then
        begin
            // Aufrumen und raus
            for a := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
              if assigned(results[a]) then results[a].Free;
            exit;
        end;
    end;
  end;
  
  for a := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
    if assigned(results[a]) then results[a].Free;

    ende := GetTickCount;
    ApproxTimeNeeded := Ende - Start;
    MemApproxLog.Lines.Add(GenerateStatisticsLog);
    go_on := False;

    if CBApproxAutoSave.Checked then
    begin
      case Approx_TextSize  of
          10240     : mb := '10kb';
          102400    : mb := '100kb';
          1024*1024 : mb := '1mb';
          1024*10240: mb := '10mb';
          else        mb := '50mb';
      end;
      FileName := ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('Approx_%s_%d_%d_%s_%d_(%d).dpl',
                      [StringReplace(DateTimeToStr(Now), ':','',[rfReplaceAll]),
                            Approx_Max_m, Approx_Max_Sigma, mb, Approx_ErrorQuote, Approx_Iterations]);
      SaveApproxData(FileName);

    end;



end;

procedure TForm1.BtnApproxOptionsUptadeClick(Sender: TObject);
begin
  // Werte ndern
  Approx_ITERATIONS := SEApproxIterations.Value;
  case CBApproxTextSize.ItemIndex of
    0: Approx_TextSize := 10240;
    1: Approx_TextSize := 102400;
    2: Approx_TextSize := 1024*1024;
    3: Approx_TextSize := 1024*10240;
    else Approx_TextSize := 1024*10240*5;
  end;
  Approx_MAX_SIGMA := SEApproxMaxSigma.Value;
  Approx_MAX_M := SEApproxMaxM.Value;
  Approx_Errorquote := SEApproxErrorQuote.Value;
  Approx_TextCreateMode := CBApproxCreateText.ItemIndex;
  // neu Initialisieren
  InitGlobalArrays(2);
  InitMainImage;
  UpdateMainImage;
end;


// generiert aus dem Hauptbild ein weiteres Image, wsa dann gespeichert werden kann.
procedure TForm1.GenerateSaveImage(var dest: TBitmap);
var i: Integer;
    dm, ds, mainleft: Integer;
    locm,locs, hloc, wloc, s,x,y: Integer;
begin
    mainleft := 60;
    dest.Canvas.Draw(mainleft,40,ImgBestAlgorithms.Picture.Bitmap);

     case Suchmodus of
          0: begin
              locm := max_m;
              locs := max_Sigma;
              hloc := H;
              wloc := W;
          end;
          1: begin
              locm := Multi_max_m;
              locs := Multi_max_Sigma;
              hloc := Multi_H;
              wloc := Multi_W;
          end
          else begin
              locm := Approx_max_m;
              locs := Approx_max_Sigma;
              hloc := Approx_H;
              wloc := Approx_W;
          end;
     end;

    case locm of
      0..10 : dm := 1;
      11..50 : dm := 5;
      51..100: dm := 10;
      101..200: dm := 20;
      else dm := 50;
    end;
    case locs of
      0..10 : ds := 1;
      11..50 : ds := 5;
      51..100: ds := 10;
      101..200: ds := 20;
      else ds := 50;
    end;

    dest.Canvas.Font.Size := 16;
    dest.Canvas.Brush.Style := bsClear;

    // m-Achse
    y := dest.Height - 30 - (dest.Canvas.TextHeight('m') Div 2);
    dest.Canvas.TextOut(dest.Width - 18, y, 'm');

    i := mainleft;
    dest.Canvas.MoveTo(i, dest.Height-35);
    dest.Canvas.LineTo(i, dest.Height-25);

    i := (dm * wloc) {- wloc} + mainleft;
    s := dm;
    repeat
      dest.Canvas.MoveTo(i, dest.Height-35);
      dest.Canvas.LineTo(i, dest.Height-25);

      x := i - (dest.Canvas.TextWidth(intToStr(s)) div 2);
      dest.Canvas.TextOut(x, dest.Height-25, intToStr(s));

      inc(i,(dm * wloc));
      inc(s, dm);
    until (i > dest.Width-40);


    // Sigma-Achse
     i := 40 + (locs-1)*hloc;
     dest.Canvas.MoveTo(mainleft - 5, i);
     dest.Canvas.LineTo(mainleft-15, i);

     s := ds;
     i :=  40 + (locs - ds)*hloc;
     repeat
      dest.Canvas.MoveTo(mainleft-5, i);
      dest.Canvas.LineTo(mainleft-15, i);
      x := mainleft - 18 - (dest.Canvas.TextWidth(IntToStr(s)));
      y := i - (dest.Canvas.TextHeight(IntToStr(s)) div 2 );
      dest.Canvas.TextOut(x,y,IntToStr(s));
      dec(i, (ds*hloc));
      inc(s,ds);

     until (i < 40);

     dest.Canvas.Font.Name := 'Symbol';
     x := mainleft - 10 - (dest.Canvas.TextWidth('|S|') div 2  );
     dest.Canvas.TextOut(x, 0, '|S|');
end;

procedure TForm1.PopSaveImageClick(Sender: TObject);
var mb: string;
  dest: TBitmap;
begin
  case TextSize  of
          10240     : mb := '10kb';
          102400    : mb := '100kb';
          1024*1024 : mb := '1mb';
          1024*10240: mb := '10mb';
          else        mb := '50mb';
      end;

  case Suchmodus of
    0: SaveImageDialog.FileName :=
                      ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('Simple_%d_%d_%s_(%d).bmp', [Max_m, Max_Sigma, mb, Iterations]);

    1: SaveImageDialog.FileName := ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('Multi_%d_%d_%s_%d_(%d).bmp',
                      [Multi_Max_m, Multi_Max_Sigma, mb, Multi_PCount, Multi_Iterations]);

    2: SaveImageDialog.FileName := ExtractFilePath(ParamStr(0)) + 'Daten\' +
                      Format('Approx_%d_%d_%s_%d_(%d).bmp',
                      [Approx_Max_m, Approx_Max_Sigma, mb, Approx_ErrorQuote, Approx_Iterations]);
  end;

  if SaveImageDialog.Execute then
  begin
    dest := TBitmap.Create;
    dest.Width := ImgBestAlgorithms.Picture.Bitmap.Width + 100;
    dest.Height := ImgBestAlgorithms.Picture.Bitmap.Height + 80;
    GenerateSaveImage(dest);
    dest.SaveToFile(SaveImageDialog.FileName);
    dest.Free
  end;
end;

procedure TForm1.DetailszudieserZeile1Click(Sender: TObject);
begin
    case Suchmodus of
          0: begin
              DetailForm.GetSimpleStats(0, Max_M, lastsigma, TextSize);
              DetailForm.DrawSimpleDetails;
              DetailForm.Show;
          end;
          1: begin
              DetailForm.GetMultiStats(0,  Multi_Max_M, Multi_lastsigma, Multi_PCount, Multi_TextSize);
              DetailForm.DrawMultiDetails;
              DetailForm.Show;
          end;
          2: begin
              DetailForm.GetApproxStats(0, Approx_Max_M, Approx_lastsigma, Approx_ErrorQuote, Approx_TextSize);
              DetailForm.DrawApproxDetails;
              DetailForm.Show;
          end;
    end;
end;

procedure TForm1.DetailszudieserSpalte1Click(Sender: TObject);
begin
    case Suchmodus of
          0: begin
              DetailForm.GetSimpleStats(1,  Max_Sigma, lastM, TextSize);
              DetailForm.DrawSimpleDetails;
              DetailForm.Show;
          end;
          1: begin
              DetailForm.GetMultiStats(1,  Multi_Max_Sigma, Multi_lastM,  Multi_PCount, Multi_TextSize);
              DetailForm.DrawMultiDetails;
              DetailForm.Show;
          end;
          2: begin
              DetailForm.GetApproxStats(1, Approx_Max_Sigma,Approx_lastM, Approx_ErrorQuote, Approx_TextSize);
              DetailForm.DrawApproxDetails;
              DetailForm.Show;
          end;
    end;
end;

end.
